﻿Imports System.Text
Imports NationalInstruments.NI4882    'GPIBクラスのインポート
Public Class GPIB_NI

    '(0)クラス内変数
    Private GpibDevice As Device                                                        'GPIB デバイス
    Public MsgBuf As String = ""                                                        '受信データ

    '(1)接続
    Public Function OpenInterface(ByVal BoardID As String, ByVal PrimaryAddress As String) As Boolean
        Dim ret As Boolean = False

        Try
            GpibDevice = New Device(Convert.ToInt32(BoardID), Convert.ToByte(PrimaryAddress), 0, TimeoutValue.T1s)  'GPIBオブジェクト生成
            ret = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        OpenInterface = ret
    End Function

    '(2)切断
    Public Function CloseInterface() As Boolean
        Dim ret As Boolean = False

        Try
            If Not (GpibDevice Is Nothing) Then
                GpibDevice.Dispose()                                                    'GPIBオブジェクト破棄
            End If
            ret = True
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        CloseInterface = ret
    End Function

    '(3)コマンド送信
    Public Function SendMsg(ByVal strMsg As String) As Boolean
        Dim ret As Boolean = False

        Try
            strMsg += vbCrLf                                                            'ターミネータ「CR+LF」を付加
            GpibDevice.Write(strMsg)                                                    '送信バッファに書き込み
            ret = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        SendMsg = ret
    End Function

    '(4)受信
    Public Function ReceiveMsg(ByVal timeout_ms As Long) As Boolean
        Dim ret As Boolean = False
        Dim rcv As String = ""
        Dim buf As New StringBuilder()
        Dim sw As New Stopwatch()

        MsgBuf = ""                                                                     '受信データをクリア
        sw.Start()                                                                      'タイムアウト用ストップウォッチを開始
        'ターミネータ「LF」を受信するまでループ
        Do
            Try
                rcv = ""
                rcv = GpibDevice.ReadString()                                           '受信バッファから読み取り
                rcv = rcv.Replace(vbCr, "")                                             '受信データ内の「CR」を削除
                If rcv.IndexOf(vbLf) >= 0 Then                                          'ターミネータ「LF」を受信したら終了
                    rcv = rcv.Substring(0, rcv.IndexOf(vbLf))                           '受信データを「LF」の手前までで切り詰め
                    buf.Append(rcv)                                                     '受信データを保存
                    MsgBuf = buf.ToString()
                    Exit Do
                Else
                    buf.Append(rcv)                                                     '受信データを保存
                End If
                'タイムアウト処理
                If sw.ElapsedMilliseconds > timeout_ms Then
                    MsgBuf = "Timeout"
                    MsgBox(MsgBuf)
                    ReceiveMsg = ret
                    Exit Function
                End If
            Catch Ex As Exception
                Dim StatusFlag As GpibStatusFlags = GpibDevice.GetCurrentStatus()
                If (StatusFlag And GpibStatusFlags.IOComplete) = 0 Then
                    'IO Complete以外の例外
                    MsgBuf = "Error"
                    MsgBox(Ex.Message)
                    ReceiveMsg = ret
                    Exit Function
                Else
                    'IO Complete例外
                    rcv = rcv.Replace(vbCr, "")                                         '受信データ内の「CR」を削除
                    If rcv.IndexOf(vbLf) >= 0 Then                                      'ターミネータ「LF」を受信したら終了
                        rcv = rcv.Substring(0, rcv.IndexOf(vbLf))                       '受信データを「LF」の手前までで切り詰め
                        buf.Append(rcv)                                                 '受信データを保存
                        MsgBuf = buf.ToString()
                        Exit Do
                    Else
                        buf.Append(rcv)                                                 '受信データを保存
                    End If
                    'タイムアウト処理
                    If sw.ElapsedMilliseconds > timeout_ms Then
                        MsgBuf = "Timeout"
                        MsgBox(MsgBuf)
                        ReceiveMsg = ret
                        Exit Function
                    End If
                End If
            End Try
        Loop
        sw.Stop()                                                                       'ストップウォッチを停止
        ret = True

        ReceiveMsg = ret
    End Function

    '(5)コマンド送受信
    Public Function SendQueryMsg(ByVal strMsg As String, ByVal timeout_ms As Long) As Boolean
        Dim ret As Boolean = False

        ret = SendMsg(strMsg)                                                           'コマンド送信
        If ret Then
            If InStr(strMsg, "?") <> 0 Then
                ret = ReceiveMsg(timeout_ms)                                            '送信が成功したら応答を受信
            End If
        End If

        SendQueryMsg = ret
    End Function


End Class
